﻿//
// Globalnie uzywane narzedzia i klasy
//
(function ($) {
    $.fn.setEqualSizes = function () {
        var maxWidth = 0;
        var maxHeight = 0;

        this.each(function () {
            if ($(this).hasClass("N610_calculate_width")) {
                maxWidth = Math.max(maxWidth, $(this).outerWidth());
            }
            if ($(this).hasClass("N610_calculate_height")) {
                maxHeight = Math.max(maxHeight, $(this).outerHeight());
            }
        });

        if (maxHeight < MIN_HEIGHT) maxHeight = MIN_HEIGHT;
        if ($(this).hasClass("msDropdown")) {
            maxWidth += 30;
            this.each(function () {
                if ($(this).hasClass("N610_calculate_width")) {
                    $(this).width(maxWidth);
                }
            });
        }
        else {
            this.each(function () {
                $(this).css("-webkit-box-sizing", "border-box").css("-moz-box-sizing", "border-box").css("box-sizing", "border-box");
                /* Safari/Chrome, other WebKit */ /* Firefox, other Gecko */ /* Opera/IE 8+ */
                if ($(this).hasClass("N610_calculate_width")) {
                    $(this).width(maxWidth);
                }
                if ($(this).hasClass("N610_calculate_height")) {
                    $(this).height(maxHeight);
                }
            });
        }
        var maxArray = new Array();
        maxArray.push(maxWidth);
        maxArray.push(maxHeight);
        return maxArray;
    };
})(jQuery);

(function ($) {
    $.fn.vAlign = function () {
        return this.each(function (i) {
            var ah = $(this).height();
            var ph = $(this).parent().height();
            var mh = Math.ceil((ph - ah) / 2);
            $(this).css('margin-top', mh);
        });
    };
})(jQuery);

(function ($) {
    $.fn.getMaxSize = function () {
        var maxWidth = 0;
        var maxHeight = 0;

        this.each(function () {
            maxWidth = Math.max(maxWidth, $(this).outerWidth());
            maxHeight = Math.max(maxHeight, $(this).outerHeight());
        });

        var maxArray = new Array();
        maxArray.push(maxWidth);
        maxArray.push(maxHeight);
        return maxArray;
    };
})(jQuery);


function getIntValue(element, property) {
    var property = parseInt($(element).css(property).replace('px', ''));
    if (isNaN(property)) return 0;
    else return property;
}

function MatchingTable() {
    this.table = new Array();
    this.put = function (key, value) {
        this.table[key] = value;
    }
    this.getValue = function (key) {
        return this.table[key];
    }
    this.isKeyIn = function (key) {
        if (this.table[key] != undefined) return true;
        return false;
    }
    this.isValueIn = function (val) {
        for (i in this.table)
            if (this.table[i] == val) return true;

        return false;
    }
    this.remove = function (key) {
        var tmpTable = new Array();

        for (i in this.table)
            if (i != key) tmpTable[i] = this.table[i];

        this.table = tmpTable;
    }
    this.getKeyByValue = function (value) {
        for (i in this.table)
            if (this.table[i] == value) return i;
        return null;
    }
    this.getKeysByValue = function (value) {
        var keysArray = new Array();
        for (i in this.table)
            if (this.table[i] == value) keysArray.push(i);

        return keysArray;
    }
    this.removeByValue = function (val) {
        var tmpTable = new Array();
        for (i in this.table)
            if (this.table[i] != val) tmpTable[i] = this.table[i];
        this.table = tmpTable;
    }
    this.clear = function () { this.table = new Array(); }
}

function coord(x, y) { this.x = x; this.y = y }

var matchings = new MatchingTable();
var boxPositions= new Array();

function setup_Questions_OpenGap() {
    var maxSize = $("input.N610_samesize[id ^= 'in']").getMaxSize();
    if (maxSize[0] > ((CANVAS_WIDTH / 2) - 20)) {
        $("input.N610_samesize[id ^= 'in']").each(function () {
            $(this).css("width", (CANVAS_WIDTH / 2) - 20);
        });
    }
    $("input.N610_samesize[id ^= 'in']").setEqualSizes();
}

function setup_Questions_MovingBox() {
    var maxSize = $("div.N610_samesize[id ^= 'divVal']").getMaxSize();
    if (maxSize[0] > ((CANVAS_WIDTH/2) - 20)) {
        $("div.N610_samesize[id ^= 'divVal']").each(function () {
            $(this).css("width", (CANVAS_WIDTH/2) - 20);
        });		
    }
    var boxSize = $("div.N610_samesize[id ^= 'divVal']").setEqualSizes();
    $("div.N610_samesize[id ^='in_']").each(function () {
        if ($(this).hasClass("N610_calculate_width") && boxSize[0] > 0) {
            $(this).css("width", boxSize[0]);
        }
        if ($(this).hasClass("N610_calculate_height") && boxSize[1] > 0) {
            $(this).css("height", boxSize[1]);
        }
    });		

    //dodanie i ustawienie obszarow
    $("div[class *= draggable]").draggable({
        containment: "#containment-wrapper",
        scroll: false
    }).each(function () {
        boxPositions[$(this).attr("id")] = new coord($(this).position().left, $(this).position().top);
    });

    $("#containment-wrapper div[class *= draggable]").draggable({ stack: "#containment-wrapper div" });

    var parent = $("#containment-wrapper");
    var correct_stop_left = $(parent).offset().left;
    var correct_stop_top = $(parent).offset().top;

    $("div[class *= droppable], div[id = containment-wrapper]").droppable({
        over: function (event, ui) { if ($(this).attr("id") != "containment-wrapper") $(this).addClass("dropHover"); },
        out: function (event, ui) { if ($(this).attr("id") != "containment-wrapper") $(this).removeClass("dropHover"); },
        disabled: false,
        greedy: true,
        drop: function (event, ui) {
            var boxId = ui.draggable.attr("id").substring(ui.draggable.attr("id").lastIndexOf("_") + 1);
            var areaId = $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1);

            if (areaId != null)
                if (boxId != null) {
                    if ($(this).attr("id") == "containment-wrapper") {
                        if (matchings.isValueIn(boxId)) {
                            $("#hin_" + matchings.getKeyByValue(boxId)).val("");
                            $("#divDrop_" + matchings.getKeyByValue(boxId)).droppable("option", "disabled", false);
                            matchings.removeByValue(boxId);
                            $("#divDrag_" + boxId).removeClass("N610_elementSelected");
                        }
                    }
                    else {
                        $(this).removeClass("dropHover");
                        $(this).droppable("option", "disabled", true);
                        if (matchings.isValueIn(boxId)) {
                            $("#hin_" + matchings.getKeyByValue(boxId)).val("");
                            $("#divDrop_" + matchings.getKeyByValue(boxId)).droppable("option", "disabled", false);
                            matchings.removeByValue(boxId);
                            $("#divDrag_" + boxId).removeClass("N610_elementSelected");
                        }
                        matchings.put(areaId, boxId);
                        $("#hin_" + matchings.getKeyByValue(boxId)).val(boxId);
                        $("#divDrag_" + boxId).addClass("N610_elementSelected");

                        var init_left = boxPositions[ui.draggable.attr("id")].x;
                        var init_top = boxPositions[ui.draggable.attr("id")].y;

                        var stop_left = $(this).offset().left - correct_stop_left;
                        var stop_top = $(this).offset().top - correct_stop_top;

                        var dx = stop_left - init_left;
                        var dy = stop_top - init_top;

                        ui.draggable.animate({ left: dx, top: dy }, "slow");
                    }
                }
        }
    });
}

function setup_Questions_MovingBoxCheck() {
}

function setup_Questions_MovingBoxArea(){
    var _areaNumber = $("div[id ^= 'exerciseArea_']").length;
	var _boxNumber = $("div[id ^= 'divBox']").length;
	var _areaWidth = Math.floor((CANVAS_WIDTH - (_areaNumber * CANVAS_PADDING) - (2 * _areaNumber * CANVAS_PADDING)) / _areaNumber) - 30;
	if (_areaWidth > 0) {
	    $("table[id ^= 'divVal']").each(function () {
	        if ($(this).hasClass("N610_calculate_width")) {
	            $(this).width(Math.ceil(_areaWidth * 0.8));
	        }
	    });
	}
    
	var boxSize = $("table[id ^= 'divVal']").setEqualSizes();
	//dodanie i ustawienie obszarow
	var _areaHeight = Math.floor(2*_boxNumber*boxSize[1]);
	$("div[id ^= 'exerciseArea_']").each(function () {
	    if ($(this).hasClass("N610_calculate_width") && _areaWidth > 0) {
	        $(this).css("width", _areaWidth);
	    }
	    if ($(this).hasClass("N610_calculate_height") && _areaHeight > 0) {
	        $(this).css("height", _areaHeight);
	    }
	});			
    
	$("div[class *= draggable]").draggable({
		containment: "#containment-wrapper",
		scroll: false}).each(function() {
		boxPositions[$(this).attr("id")] = new coord($(this).position().left, $(this).position().top);
	});
    $("#containment-wrapper div[class *= draggable]").draggable({stack: "#containment-wrapper div"});
	$("div[class *= droppable], div[id = containment-wrapper]").droppable({
		disabled: false,
		greedy: true,
		drop: function (event,ui) {
		    var boxId = ui.draggable.attr("id").substring(ui.draggable.attr("id").lastIndexOf("_")+1);
		    var areaId = $(this).attr("id").substring($(this).attr("id").lastIndexOf("_")+1);
			if (areaId != null)
                if (boxId != null) {
                    if (areaId == "containment-wrapper") {
                        if ($("#hin_" + boxId).val() != "") {
                            $("#hin_" + boxId).val("");
                            $("#divBox_" + boxId).removeClass("N610_elementSelected");
                        }
                    }
                    else {
                        $("#hin_" + boxId).val(areaId);
                        $("#divBox_" + boxId).addClass("N610_elementSelected");
                    }
                }
		}	
	});
}

function setup_Questions_MovingBoxArea_Check() {
}

var paper;
var lineReferences;
var rightSentences;
var leftSentences;
function drawLineBetween(leftSentenceId, rightSentenceId, lineColor, select) {
    var lsentence = $("#SENTENCE_LEFT_" + leftSentenceId);
    var rsentence = $("#SENTENCE_RIGHT_" + rightSentenceId);

    if (rsentence && rsentence.length > 0 && lsentence && lsentence.length > 0) {
        var rmargin = getIntValue(lsentence, "margin-right");
        var lmargin = getIntValue(rsentence, "margin-left");

        var line = paper.path("M" + Math.round(lsentence.position().left + lsentence.outerWidth(true) - rmargin) + " " +
		Math.round(lsentence.position().top + lsentence.outerHeight(true) / 2) +
		"L" + Math.round(rsentence.position().left + lmargin) + " " + Math.round(rsentence.position().top + rsentence.outerHeight(true) / 2));

        line.attr({ stroke: lineColor, 'stroke-width': 3 });
        if (select) {
            $(lsentence).addClass("N610_elementSelected");
        }
        return line;
    }
}

function setup_Matching(dnd, resolve, subWidth) {
    if (!subWidth) subWidth = 0;
    $("#containment-wrapper").css("width", CANVAS_WIDTH - subWidth);
    $("#drawing-wrapper").css("width", CANVAS_WIDTH - subWidth);
    paper = new Raphael("drawing-wrapper", "100%", "100%");
    lineReferences = new MatchingTable();
    leftSentences = new MatchingTable();
    rightSentences = new MatchingTable();
    if (dnd) {
        $("div[class *= draggable]").draggable({
            containment: "#containment-wrapper",
            scroll: false,
            revert: true,
            helper: 'clone',
            opacity: 0.7,
            snap: true,
            snapMode: 'inner',
            start: function (event, ui) {
                var leftSentenceId = $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1);
                matchings.remove(leftSentenceId);
                $("#hin_" + leftSentenceId).val("");
                if (lineReferences.isKeyIn(leftSentenceId)) {
                    var line = lineReferences.getValue(leftSentenceId);
                    line.remove();
                    lineReferences.remove(leftSentenceId);
                    $(this).removeClass("N610_elementSelected");
                }
            }
        });


        $("#containment-wrapper div[class *= draggable]").draggable({ stack: "#containment-wrapper div" });

        $("div[class *= droppable]").droppable({
            disabled: false,
            drop: function (event, ui) {
                var leftSentenceId = ui.draggable.attr("id").substring(ui.draggable.attr("id").lastIndexOf("_") + 1);
                var rightSentenceId = $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1);
                if (leftSentenceId != null && rightSentenceId != null) {
                    matchings.put(leftSentenceId, rightSentenceId);
                    lineReferences.put(leftSentenceId, drawLineBetween(leftSentenceId, rightSentenceId, LINE_COLOR, true));
                    $("#hin_" + leftSentenceId).val(rightSentenceId);
                }
            }
        });
    }

    var elWidth = Math.round(((CANVAS_WIDTH -subWidth)/ 2) - (CANVAS_MIDDLE_WIDTH / 2) - CANVAS_PADDING);
    $("#left_sentences div.N610_calculate_width, #right_sentences div.N610_calculate_width").each(function () { $(this).css("width", elWidth); });
    $("#left_sentences div.draggable, #right_sentences div.droppable").setEqualSizes();

    if (!dnd) {
        $("div[class *= draggable]").draggable("option", "disabled", true);
        $("div[class *= draggable]").css("opacity", 1);
        $("input[id ^= 'hin_']").each(function () {
            var _answerid = $(this).val().substring(0, $(this).val().lastIndexOf("_"));
            if (_answerid != '') {
                var _correct = $(this).val().substring($(this).val().lastIndexOf("_") + 1);
                var _lineColor = LINE_COLOR_RESOLVE;
                if (!resolve) {
                    if (_correct == "1") {
                        _lineColor = LINE_COLOR_CORRECT;
                    }
                    else {
                        _lineColor = LINE_COLOR_INCORRECT;
                    }
                }
                drawLineBetween($(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1), _answerid, _lineColor, false);
            }
        });
    }
}

function setup_Questions_ABCD(isMultipleChoice) {
    $("div[id ^= 'question_']").each(function () {
        $(this).find("div[id ^= 'in_']").click(function () {
            var _qid = $(this).attr("id").substring($(this).attr("id").indexOf("_") + 1, $(this).attr("id").lastIndexOf("_") - $(this).attr("id").indexOf("_")+2);
            var _id = $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1);
            var _currenctVal = $("#hin_" + _qid + "_" + _id).val();
            if (isMultipleChoice != "1") {
                $("input[id^='hin_" + _qid + "']").val("0");
                $("div[id^='in_" + _qid + "']").removeClass("N610_elementSelected");
            }
            if (_currenctVal != "1") {
                $("#hin_" + _qid + "_" + _id).val("1");
                $("div[id^='in_" + _qid + "_" + _id + "']").addClass("N610_elementSelected");      
            }
            else {
                $("#hin_" + _qid + "_" + _id).val("0");
                $("div[id^='in_" + _qid + "_" + _id + "']").removeClass("N610_elementSelected"); 
            }
        });
    });
}


function setupBreadcrumbNavigation(pageSize, totalNumbers, currentIndex) {
    var pages_counter = Math.floor(totalNumbers / pageSize);
    if (pages_counter * pageSize < totalNumbers) pages_counter++;
    var currPage = Math.floor(currentIndex / pageSize);
    if (currPage * pageSize < currentIndex) currPage++;
    var blockFullWidth = NUM_BLOCK_WIDTH + 2; //2 - margines lewy
    var windowSize = blockFullWidth * pageSize;
    var totalWidth = windowSize * pages_counter;
    var startLeft = -windowSize * (currPage - 1);
    var maxLeft = windowSize - totalWidth;
    var actualPage = currPage;

    $("div.N610_pageNumBlock, div.N610_pageNumBlockCurrent, div.N610_pageNumBlockNav").width(NUM_BLOCK_WIDTH).height(NUM_BLOCK_HEIGHT);
    $("#exercisePaging").width(windowSize + 2 * blockFullWidth).height(NUM_BLOCK_HEIGHT);
    $("#N610_numberSlide").width(windowSize).height(NUM_BLOCK_HEIGHT);
    $("#N610_numberSlide .N610_numberStuff").width(windowSize).height(NUM_BLOCK_HEIGHT);
    $("#N610_numberSlide .N610_numberCover").width(totalWidth).height(NUM_BLOCK_HEIGHT).css("left", startLeft + "px");

    $('#buttonPrev').click(function () {
        if ($('#N610_numberSlide .N610_numberCover').css("left").replace("px", "") < 0) {
            $('#N610_numberSlide .N610_numberCover').not(":animated").animate({ "left": "+=" + (windowSize) + "px" }, "slow", "linear", function () {
                actualPage--;

                $("#buttonPrev").css("visibility", (actualPage == 1) ? "hidden" : "visible");
                $("#buttonNext").css("visibility", (actualPage == pages_counter) ? "hidden" : "visible");
            });
        }
    });

    $('#buttonNext').click(function () {
        if ($('#N610_numberSlide .N610_numberCover').css("left").replace("px", "") > maxLeft) {
            $('#N610_numberSlide .N610_numberCover').not(":animated").animate({ "left": "-=" + (windowSize) + "px" }, "slow", "linear", function () {
                actualPage++;

                $("#buttonPrev").css("visibility", (actualPage == 1) ? "hidden" : "visible");
                $("#buttonNext").css("visibility", (actualPage == pages_counter) ? "hidden" : "visible");
            });
        }
    });

    $(".positionable").vAlign();
    $("#exerciseBreadcrumb").corner("5px");

    if (totalNumbers == 0) {
        //$("#exerciseBreadcrumb").remove();
        //$("#spacerDiv").remove();
    }
    else {
        $("#buttonPrev").css("visibility", (currPage == 1) ? "hidden" : "visible");
        $("#buttonNext").css("visibility", (currPage == pages_counter) ? "hidden" : "visible");
    }
}

function loadExercise(vDomain,vContextObjectID,vCourseID,vUnitID,vExerciseID,vModeID) {
    var _mgr = new GAjaxManager({
        Domain: vDomain,
        BID: vContextObjectID,
        Function: 'loadExercise',
        NameSpace: AJAX_NAMESPACE,
        FormatParams: function (xml) {
            xml.Node("ContextObjectID", vContextObjectID);
            xml.Node("CourseID", vCourseID);
            xml.Node("UnitID", vUnitID);
            xml.Node("ExerciseID", vExerciseID);
	        xml.Node("ModeID", vModeID);              
            xml.Node("Params", AJAX_PARAMS);
        },
        OnSuccess: function (content) {
            $('#exercise').html(content);
            if (typeof (fixBorderContainerHeight) == "function") {
                fixBorderContainerHeight();
            }
        },
        OnError: function (errorMessage) {
            $('#exercise').html(errorMessage);
        }
    });
    _mgr.process();
}

function loadCourseMenu(vDomain,vContextObjectID,vCourseID,vModeID) {
    var _mgr = new GAjaxManager({
	    Domain:vDomain,
	    BID:vContextObjectID,
	    Function:'loadCourseMenu',
	    NameSpace:AJAX_NAMESPACE,
	    FormatParams:function(xml) {
	        xml.Node("ContextObjectID",vContextObjectID);  	        
	        xml.Node("CourseID",vCourseID);	
	        xml.Node("ModeID", vModeID);  	        	                     	        
	        xml.Node("Params",AJAX_PARAMS);
	    },
        OnSuccess: function (content) {
            $('#exercise').html(content);
            if (typeof (fixBorderContainerHeight) == "function") {
                fixBorderContainerHeight();
            }
        },
        OnError: function (errorMessage) {
            $('#exercise').html(errorMessage);
        }
    });
    _mgr.process();
}


function loadNextExercise(vDomain,vContextObjectID,vCourseID,vUnitID,vExerciseID,vModeID) {
    var _mgr = new GAjaxManager({
	    Domain:vDomain,
	    BID:vContextObjectID,
	    Function:'loadNextExercise',
	    NameSpace:AJAX_NAMESPACE,
	    FormatParams:function(xml) {
	        xml.Node("ContextObjectID",vContextObjectID);  	        
	        xml.Node("CourseID",vCourseID);	  
	        xml.Node("UnitID",vUnitID);	
	        xml.Node("ExerciseID",vExerciseID);	
            xml.Node("ModeID", vModeID);	        	        	                     	        
	        xml.Node("Params",AJAX_PARAMS);
	    },
        OnSuccess: function (content) {
            $('#exercise').html(content);
            if (typeof (fixBorderContainerHeight) == "function") {
                fixBorderContainerHeight();
            }
        },
        OnError: function (errorMessage) {
            $('#exercise').html(errorMessage);
        }
    });
    _mgr.process();
}

function loadPreviousExercise(vDomain,vContextObjectID,vCourseID,vUnitID,vExerciseID,vModeID) {
    var _mgr = new GAjaxManager({
	    Domain:vDomain,
	    BID:vContextObjectID,
	    Function:'loadPreviousExercise',
	    NameSpace:AJAX_NAMESPACE,
	    FormatParams:function(xml) {
	        xml.Node("ContextObjectID",vContextObjectID);  	        
	        xml.Node("CourseID",vCourseID);	  
	        xml.Node("UnitID",vUnitID);	
	        xml.Node("ExerciseID",vExerciseID);
            xml.Node("ModeID", vModeID);	        		        	                     	        
	        xml.Node("Params",AJAX_PARAMS);
	    },
        OnSuccess: function (content) {
            $('#exercise').html(content);
            if (typeof (fixBorderContainerHeight) == "function") {
                fixBorderContainerHeight();
            }
        },
        OnError: function (errorMessage) {
            $('#exercise').html(errorMessage);
        }
    });
    _mgr.process();
}

function resolveExercise(vDomain, vContextObjectID, vCourseID, vUnitID, vExerciseID,vModeID) {
    var _mgr = new GAjaxManager({
        Domain: vDomain,
        BID: vContextObjectID,
        Function: 'resolveExercise',
        NameSpace: AJAX_NAMESPACE,
        FormatParams: function (xml) {
            xml.Node("ContextObjectID", vContextObjectID);
            xml.Node("CourseID", vCourseID);
            xml.Node("UnitID", vUnitID);
            xml.Node("ExerciseID", vExerciseID);
            xml.Node("ModeID", vModeID);             
            xml.Node("Params", AJAX_PARAMS);
            formatConfigNode(xml);
        },
        OnSuccess: function (content) {
            $('#exercise').html(content);
            if (typeof (fixBorderContainerHeight) == "function") {
                fixBorderContainerHeight();
            }
        },
        OnError: function (errorMessage) {
            $('#exercise').html(errorMessage);
        }
    });
    _mgr.process();
}

function checkExercise(vDomain, vContextObjectID, vCourseID, vUnitID, vExerciseID,vModeID) {
    if (typeof (formatCheck) == "function") {
        var _mgr = new GAjaxManager({
            Domain: vDomain,
            BID: vContextObjectID,
            Function: 'checkExercise',
            NameSpace: AJAX_NAMESPACE,
            FormatParams: function (xml) {
                xml.Node("ContextObjectID", vContextObjectID);
                xml.Node("CourseID", vCourseID);
                xml.Node("UnitID", vUnitID);
                xml.Node("ExerciseID", vExerciseID);
                xml.Node("ModeID", vModeID);                
                xml.Node("Params", AJAX_PARAMS);
                formatCheck(xml);
                formatConfigNode(xml);
            },
            OnSuccess: function (content) {
                $('#exercise').html(content);
                if (typeof (fixBorderContainerHeight) == "function") {
                    fixBorderContainerHeight();
                }
            },
            OnError: function (errorMessage) {
                $('#exercise').html(errorMessage);
            }
        });
        _mgr.process();
    }
}

function formatConfigNode(xml) {
    xml.BeginNode("CONFIG");
    formatObjectOrder(xml);
    formatObjectHW(xml);
    xml.EndNode();
    return true;
}

function formatObjectOrder(xml) {
    xml.Node("OBJECT_ORDER", $("#__oo").val());
}

function formatObjectHW(xml) {
    var _N610_fhwList = $("*.N610_fhw");
    if ((_N610_fhwList) && (_N610_fhwList.length > 0)) {
        xml.BeginNode("OBJECT_SIZE");
        $(_N610_fhwList).each(function () {
            xml.BeginNode("OBJECT");
            xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1));
            xml.Attrib("width", $(this).outerWidth());
            xml.Attrib("height", $(this).outerHeight());
            xml.EndNode();
        });
        xml.EndNode();
    }
    var _N610_fwList = $("*.N610_fw");
    if ((_N610_fwList) && (_N610_fwList.length > 0)) {
        xml.BeginNode("OBJECT_SIZE");
        $(_N610_fwList).each(function () {
            xml.BeginNode("OBJECT");
            xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1));
            xml.Attrib("width", $(this).outerWidth());
            xml.EndNode();
        });
        xml.EndNode();
    }
    var _N610_fhList = $("*.N610_fh");
    if ((_N610_fhList) && (_N610_fhList.length > 0)) {
        xml.BeginNode("OBJECT_SIZE");
        $(_N610_fhList).each(function () {
            xml.BeginNode("OBJECT");
            xml.Attrib("id", $(this).attr("id").substring($(this).attr("id").lastIndexOf("_") + 1));
            xml.Attrib("height", $(this).outerHeight());
            xml.EndNode();
        });
        xml.EndNode();
    }
}
